# Open Data files for Saas Demo


This ZIP file contains files for studying and researching about this participation platform.


## Core

### users

* id: The unique identifier of the user
* name: The display name of user
* nickname: The username of the user
* about: The about text of the user
* avatar_url: The avatar of the user
* profile_url: The profile url
* direct_messages_enabled: Whether the user allows direct messages
* deleted: Whether the user is deleted or not
* badge: The badge of the user
* groups: The id and name of the user group


### metrics

* day: The day this metric was created
* metric_type: The type of the metric
* cumulative: The total number of the metric at this day
* quantity: The number of the metrics for this day


### taxonomies

* id: The unique identifier of this taxonomy
* name: The name of this taxonomy
* parent_id: The unique identifiers of this taxonomy parent (if any)
* weight: The order in which this taxonomy is shown
* children_count: The count of the children that this taxonomy has
* taxonomizations_count: The count of the resources that use this taxonomy
* created_at: The date when this taxonomy was created
* updated_at: The date when this taxonomy was updated for the last time
* filters_count: The number of filters that is using this taxonomy
* filter_items_count: The number of items filters that are using this taxonomy
* part_of: Used to detect if this taxonomy is part of another taxonomy
* is_root: True if this taxonomy do not have any parent



## Spaces

### participatory_processes

* id: The unique identifier of this process
* title: The process title
* slug: The process slug (used for identification purposes, for the URL)
* reference: The unique reference of the space
* created_at: The date this space was created
* updated_at: The last date this space was updated
* published_at: The date this space was published
* follows_count: The number of users following this space
* hashtag: The process hashtag, used for Twitter/X
* short_description: A short description of the process
* description: A long description of the process
* promoted: Wheter the process is promoted or not
* url: The URL of the space
* subtitle: The subtitle of the process
* remote_hero_image_url: The URL of the process hero image
* announcement: The announcement (callout) information
* start_date: The start date of the process
* end_date: The end date of the process
* developer_group: The developer group of the process. This is the organization that is promoting the process.
* local_area: The local area of the process. This is the organization area where the process is taking place.
* meta_scope: The scope metadata of the process
* participatory_scope: The participatory scope of the process
* participatory_structure: The participatory structure of the process. This is how the process is decided.
* target: The target of the process. This is who is called to participate in the process.
* area: The area where the process is taking place
* participatory_process_group: The group of the process, if there is any
* scope: The scope of the process
* scopes_enabled: Whether the scopes are enabled or not
* participatory_process_type: The type of the process



## Components

### posts

* id: The unique identifier of this post
* author: The information of the author
* title: The title of the post
* body: The body of the post
* created_at: The date this post was created
* updated_at: The last date this post was updated
* published_at: The date this post was published
* endorsements_count: The number of endorsements this post has
* comments_count: The number of comments this post has
* follows_count: The number of follows this post has
* participatory_space: To which space (e.g. Participatory Process, or Assembly) this post belongs to
* component: The component that the post belongs to
* url: The URL for this post


### meetings

* id: The unique identifier of the meeting
* author: The data for the author of this meeting
* participatory_space: To which space (e.g. Participatory Process, or Assembly) this meeting belongs to
* taxonomies: The taxonomies that this meeting belongs to
* component: The component that the meeting belongs to
* title: The title of the meeting
* description: The description of the meeting
* start_time: The date and time that this meeting starts
* end_time: The date and time that this meeting ends
* attendees: The number of people attending this meeting
* contributions: The number of contributions in this meeting made by the atteendes
* organizations: The organizations attending this meeting
* address: The address of the meeting in case it is in person and has a physical location
* location: The location of the meeting
* reference: The unique identifier of the resource in this platform
* attachments: The number of attachments in this meeting
* url: The URL of the meeting
* related_proposals: The proposals related to this meeting
* related_results: The results related to this meeting
* published: When the meeting has been published
* withdrawn: Whether this meeting has been withdrawn
* withdrawn_at: When this meeting was withdrawn
* location_hints: A hint of the location in which the meeting is taking place
* created_at: The date at which the meeting was created
* updated_at: The time at which the meeting was last updated
* latitude: The latitude of the meeting
* longitude: The longitude of the meeting
* follows_count: The number of follows the meeting has
* private_meeting: To indicate whether the meeting is private or not
* transparent: The visabilty of the meetng for non-members
* registration_form_enabled: Whether the registration form was enabled or not
* comments: The comments data of the meeting
* online_meeting_url: The URL of the online meeting
* closing_visible: The visibilty of the meeting
* closing_report: Report of the closed meeting
* attending_organizations: The organizations attending the meeting
* registration_url: URL of the meeting registration
* decidim_user_group_id: User group ID of people involved in the meeting
* decidim_author_type: Author type of the meeting's author
* video_url: Video recording of the meeting
* audio_url: Audio recording of the meeting
* closed_at: The date at which the meeting closed
* registration_terms: The terms agreed prior to meeting participation
* available_slots: The number of slots available in a meeting
* registrations_enabled: Whether registrations were permitted
* customize_registration_email: The ability to allow a custom email at registration
* type_of_meeting: The meeting type
* iframe_access_level: The iframe access level of the meeting
* iframe_embed_type: The type of iframe embeded in the meeting
* reserved_slots: The number of reserved slots the meeting has
* registration_type: The type of registration of the meeting



